﻿//////////////////////////////////////////////
// TextureCopyEffect.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class System ;
}

namespace nkGraphics
{
	class Program ;
	class Sampler ;
	class Texture ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

#include "../Effect.h"

#include "TextureCopyEffectInfo.h"

/// Class ------------------------------------

namespace nkAstraeus
{
	class DLL_ASTRAEUS_EXPORT TextureCopyEffect final : public Effect
	{
		public :

			// Constructor, destructor
			TextureCopyEffect (System* system) noexcept ;
			virtual ~TextureCopyEffect () ;

			// Getters
			nkGraphics::Texture* getSourceTexture () const ;
			nkGraphics::Sampler* getSourceSampler () const ;

			// Setters
			void setSourceTexture (nkGraphics::Texture* value) ;
			void setSourceSampler (nkGraphics::Sampler* value) ;

			// Load
			virtual bool load () override ;
			virtual void unload () override ;

		public :

			// Statics
			static nkMemory::UniquePtr<TextureCopyEffect> create (System* system = nullptr) ;

		private :

			// Functions
			// Program
			bool _prepareProgram () ;

			// Shader
			bool _prepareShader () ;

		private :

			// Attributes
			System* _system ;

			// Program
			nkGraphics::Program* _program ;
			TextureCopyEffectInfo _programInfo ;

			// Info
			TextureCopyEffectInfo _info ;
	} ;
}